<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\StoneColor\BulkDestroyStoneColor;
use App\Http\Requests\Admin\StoneColor\DestroyStoneColor;
use App\Http\Requests\Admin\StoneColor\IndexStoneColor;
use App\Http\Requests\Admin\StoneColor\StoreStoneColor;
use App\Http\Requests\Admin\StoneColor\UpdateStoneColor;
use App\Models\StoneColor;
use Brackets\AdminListing\Facades\AdminListing;
use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Contracts\View\Factory;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Response;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\DB;
use Illuminate\View\View;

class StoneColorController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @param IndexStoneColor $request
     * @return array|Factory|View
     */
    public function index(IndexStoneColor $request)
    {
        // create and AdminListing instance for a specific model and
        $data = AdminListing::create(StoneColor::class)->processRequestAndGet(
            // pass the request with params
            $request,

            // set columns to query
            ['id', 'stone_color', 'diamond_type', 'status'],

            // set columns to searchIn
            ['id', 'stone_color']
        );

        if ($request->ajax()) {
            if ($request->has('bulk')) {
                return [
                    'bulkItems' => $data->pluck('id')
                ];
            }
            return ['data' => $data];
        }

        return view('admin.stone-color.index', ['data' => $data]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function create()
    {
        $this->authorize('admin.stone-color.create');

        return view('admin.stone-color.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param StoreStoneColor $request
     * @return array|RedirectResponse|Redirector
     */
    public function store(StoreStoneColor $request)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Store the StoneColor
        $stoneColor = StoneColor::create($sanitized);

        if ($request->ajax()) {
            return ['redirect' => url('admin/stone-colors'), 'message' => trans('brackets/admin-ui::admin.operation.succeeded')];
        }

        return redirect('admin/stone-colors');
    }

    /**
     * Display the specified resource.
     *
     * @param StoneColor $stoneColor
     * @throws AuthorizationException
     * @return void
     */
    public function show(StoneColor $stoneColor)
    {
        $this->authorize('admin.stone-color.show', $stoneColor);

        // TODO your code goes here
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param StoneColor $stoneColor
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function edit(StoneColor $stoneColor)
    {
        $this->authorize('admin.stone-color.edit', $stoneColor);


        return view('admin.stone-color.edit', [
            'stoneColor' => $stoneColor,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param UpdateStoneColor $request
     * @param StoneColor $stoneColor
     * @return array|RedirectResponse|Redirector
     */
    public function update(UpdateStoneColor $request, StoneColor $stoneColor)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Update changed values StoneColor
        $stoneColor->update($sanitized);

        if ($request->ajax()) {
            return [
                'redirect' => url('admin/stone-colors'),
                'message' => trans('brackets/admin-ui::admin.operation.succeeded'),
            ];
        }

        return redirect('admin/stone-colors');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DestroyStoneColor $request
     * @param StoneColor $stoneColor
     * @throws Exception
     * @return ResponseFactory|RedirectResponse|Response
     */
    public function destroy(DestroyStoneColor $request, StoneColor $stoneColor)
    {
        $stoneColor->delete();

        if ($request->ajax()) {
            return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
        }

        return redirect()->back();
    }

    /**
     * Remove the specified resources from storage.
     *
     * @param BulkDestroyStoneColor $request
     * @throws Exception
     * @return Response|bool
     */
    public function bulkDestroy(BulkDestroyStoneColor $request) : Response
    {
        DB::transaction(static function () use ($request) {
            collect($request->data['ids'])
                ->chunk(1000)
                ->each(static function ($bulkChunk) {
                    StoneColor::whereIn('id', $bulkChunk)->delete();

                    // TODO your code goes here
                });
        });

        return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
    }
}
