<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\RingSize\BulkDestroyRingSize;
use App\Http\Requests\Admin\RingSize\DestroyRingSize;
use App\Http\Requests\Admin\RingSize\IndexRingSize;
use App\Http\Requests\Admin\RingSize\StoreRingSize;
use App\Http\Requests\Admin\RingSize\UpdateRingSize;
use App\Models\RingSize;
use Brackets\AdminListing\Facades\AdminListing;
use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Contracts\View\Factory;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Response;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\DB;
use Illuminate\View\View;

class RingSizeController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @param IndexRingSize $request
     * @return array|Factory|View
     */
    public function index(IndexRingSize $request)
    {
        // create and AdminListing instance for a specific model and
        $data = AdminListing::create(RingSize::class)->processRequestAndGet(
            // pass the request with params
            $request,

            // set columns to query
            ['id', 'size', 'status'],

            // set columns to searchIn
            ['id', 'size']
        );

        if ($request->ajax()) {
            if ($request->has('bulk')) {
                return [
                    'bulkItems' => $data->pluck('id')
                ];
            }
            return ['data' => $data];
        }

        return view('admin.ring-size.index', ['data' => $data]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function create()
    {
        $this->authorize('admin.ring-size.create');

        return view('admin.ring-size.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param StoreRingSize $request
     * @return array|RedirectResponse|Redirector
     */
    public function store(StoreRingSize $request)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Store the RingSize
        $ringSize = RingSize::create($sanitized);

        if ($request->ajax()) {
            return ['redirect' => url('admin/ring-sizes'), 'message' => trans('brackets/admin-ui::admin.operation.succeeded')];
        }

        return redirect('admin/ring-sizes');
    }

    /**
     * Display the specified resource.
     *
     * @param RingSize $ringSize
     * @throws AuthorizationException
     * @return void
     */
    public function show(RingSize $ringSize)
    {
        $this->authorize('admin.ring-size.show', $ringSize);

        // TODO your code goes here
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param RingSize $ringSize
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function edit(RingSize $ringSize)
    {
        $this->authorize('admin.ring-size.edit', $ringSize);


        return view('admin.ring-size.edit', [
            'ringSize' => $ringSize,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param UpdateRingSize $request
     * @param RingSize $ringSize
     * @return array|RedirectResponse|Redirector
     */
    public function update(UpdateRingSize $request, RingSize $ringSize)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Update changed values RingSize
        $ringSize->update($sanitized);

        if ($request->ajax()) {
            return [
                'redirect' => url('admin/ring-sizes'),
                'message' => trans('brackets/admin-ui::admin.operation.succeeded'),
            ];
        }

        return redirect('admin/ring-sizes');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DestroyRingSize $request
     * @param RingSize $ringSize
     * @throws Exception
     * @return ResponseFactory|RedirectResponse|Response
     */
    public function destroy(DestroyRingSize $request, RingSize $ringSize)
    {
        $ringSize->delete();

        if ($request->ajax()) {
            return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
        }

        return redirect()->back();
    }

    /**
     * Remove the specified resources from storage.
     *
     * @param BulkDestroyRingSize $request
     * @throws Exception
     * @return Response|bool
     */
    public function bulkDestroy(BulkDestroyRingSize $request) : Response
    {
        DB::transaction(static function () use ($request) {
            collect($request->data['ids'])
                ->chunk(1000)
                ->each(static function ($bulkChunk) {
                    RingSize::whereIn('id', $bulkChunk)->delete();

                    // TODO your code goes here
                });
        });

        return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
    }
}
