<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\QcQuestion\BulkDestroyQcQuestion;
use App\Http\Requests\Admin\QcQuestion\DestroyQcQuestion;
use App\Http\Requests\Admin\QcQuestion\IndexQcQuestion;
use App\Http\Requests\Admin\QcQuestion\StoreQcQuestion;
use App\Http\Requests\Admin\QcQuestion\UpdateQcQuestion;
use App\Models\QcQuestion;
use Brackets\AdminListing\Facades\AdminListing;
use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Contracts\View\Factory;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Response;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\DB;
use Illuminate\View\View;
use App\Models\QcDepartment;

class QcQuestionsController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @param IndexQcQuestion $request
     * @return array|Factory|View
     */
    public function index(IndexQcQuestion $request)
    {
        // create and AdminListing instance for a specific model and
        $data = AdminListing::create(QcQuestion::class)->processRequestAndGet(
            // pass the request with params
            $request,

            // set columns to query
            ['id', 'department','question'],

            // set columns to searchIn
            ['id', 'question']
        );

        if ($request->ajax()) {
            if ($request->has('bulk')) {
                return [
                    'bulkItems' => $data->pluck('id')
                ];
            }
            return ['data' => $data];
        }

        //department_type
        $data->load(['department_type']);

        return view('admin.qc-question.index', ['data' => $data]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function create()
    {
        $this->authorize('admin.qc-question.create');

        $QcDepartment = QcDepartment::where('status',1)->get();

        return view('admin.qc-question.create',[
            'QcDepartment' => $QcDepartment,
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param StoreQcQuestion $request
     * @return array|RedirectResponse|Redirector
     */
    public function store(StoreQcQuestion $request)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Store the QcQuestion
        $qcQuestion = QcQuestion::create($sanitized);

        if ($request->ajax()) {
            return ['redirect' => url('admin/qc-questions'), 'message' => trans('brackets/admin-ui::admin.operation.succeeded')];
        }

        return redirect('admin/qc-questions');
    }

    /**
     * Display the specified resource.
     *
     * @param QcQuestion $qcQuestion
     * @throws AuthorizationException
     * @return void
     */
    public function show(QcQuestion $qcQuestion)
    {
        $this->authorize('admin.qc-question.show', $qcQuestion);

        // TODO your code goes here
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param QcQuestion $qcQuestion
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function edit(QcQuestion $qcQuestion)
    {
        $this->authorize('admin.qc-question.edit', $qcQuestion);
        $QcDepartment = QcDepartment::where('status',1)->get();


        return view('admin.qc-question.edit', [
            'qcQuestion' => $qcQuestion,
            'QcDepartment'=>$QcDepartment
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param UpdateQcQuestion $request
     * @param QcQuestion $qcQuestion
     * @return array|RedirectResponse|Redirector
     */
    public function update(UpdateQcQuestion $request, QcQuestion $qcQuestion)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Update changed values QcQuestion
        $qcQuestion->update($sanitized);

        if ($request->ajax()) {
            return [
                'redirect' => url('admin/qc-questions'),
                'message' => trans('brackets/admin-ui::admin.operation.succeeded'),
            ];
        }

        return redirect('admin/qc-questions');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DestroyQcQuestion $request
     * @param QcQuestion $qcQuestion
     * @throws Exception
     * @return ResponseFactory|RedirectResponse|Response
     */
    public function destroy(DestroyQcQuestion $request, QcQuestion $qcQuestion)
    {
        $qcQuestion->delete();

        if ($request->ajax()) {
            return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
        }

        return redirect()->back();
    }

    /**
     * Remove the specified resources from storage.
     *
     * @param BulkDestroyQcQuestion $request
     * @throws Exception
     * @return Response|bool
     */
    public function bulkDestroy(BulkDestroyQcQuestion $request) : Response
    {
        DB::transaction(static function () use ($request) {
            collect($request->data['ids'])
                ->chunk(1000)
                ->each(static function ($bulkChunk) {
                    QcQuestion::whereIn('id', $bulkChunk)->delete();

                    // TODO your code goes here
                });
        });

        return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
    }
}
