<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\QcDepartment\BulkDestroyQcDepartment;
use App\Http\Requests\Admin\QcDepartment\DestroyQcDepartment;
use App\Http\Requests\Admin\QcDepartment\IndexQcDepartment;
use App\Http\Requests\Admin\QcDepartment\StoreQcDepartment;
use App\Http\Requests\Admin\QcDepartment\UpdateQcDepartment;
use App\Models\QcDepartment;
use Brackets\AdminListing\Facades\AdminListing;
use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Contracts\View\Factory;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Response;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\DB;
use Illuminate\View\View;

class QcDepartmentController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @param IndexQcDepartment $request
     * @return array|Factory|View
     */
    public function index(IndexQcDepartment $request)
    {
        // create and AdminListing instance for a specific model and
        $data = AdminListing::create(QcDepartment::class)->processRequestAndGet(
            // pass the request with params
            $request,

            // set columns to query
            ['id', 'key', 'status'],

            // set columns to searchIn
            ['id', 'key', 'value']
        );

        if ($request->ajax()) {
            if ($request->has('bulk')) {
                return [
                    'bulkItems' => $data->pluck('id')
                ];
            }
            return ['data' => $data];
        }

        return view('admin.qc-department.index', ['data' => $data]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function create()
    {
        $this->authorize('admin.qc-department.create');

        return view('admin.qc-department.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param StoreQcDepartment $request
     * @return array|RedirectResponse|Redirector
     */
    public function store(StoreQcDepartment $request)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Store the QcDepartment
        $qcDepartment = QcDepartment::create($sanitized);

        if ($request->ajax()) {
            return ['redirect' => url('admin/qc-departments'), 'message' => trans('brackets/admin-ui::admin.operation.succeeded')];
        }

        return redirect('admin/qc-departments');
    }

    /**
     * Display the specified resource.
     *
     * @param QcDepartment $qcDepartment
     * @throws AuthorizationException
     * @return void
     */
    public function show(QcDepartment $qcDepartment)
    {
        $this->authorize('admin.qc-department.show', $qcDepartment);

        // TODO your code goes here
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param QcDepartment $qcDepartment
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function edit(QcDepartment $qcDepartment)
    {
        $this->authorize('admin.qc-department.edit', $qcDepartment);


        return view('admin.qc-department.edit', [
            'qcDepartment' => $qcDepartment,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param UpdateQcDepartment $request
     * @param QcDepartment $qcDepartment
     * @return array|RedirectResponse|Redirector
     */
    public function update(UpdateQcDepartment $request, QcDepartment $qcDepartment)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Update changed values QcDepartment
        $qcDepartment->update($sanitized);

        if ($request->ajax()) {
            return [
                'redirect' => url('admin/qc-departments'),
                'message' => trans('brackets/admin-ui::admin.operation.succeeded'),
            ];
        }

        return redirect('admin/qc-departments');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DestroyQcDepartment $request
     * @param QcDepartment $qcDepartment
     * @throws Exception
     * @return ResponseFactory|RedirectResponse|Response
     */
    public function destroy(DestroyQcDepartment $request, QcDepartment $qcDepartment)
    {
        $qcDepartment->delete();

        if ($request->ajax()) {
            return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
        }

        return redirect()->back();
    }

    /**
     * Remove the specified resources from storage.
     *
     * @param BulkDestroyQcDepartment $request
     * @throws Exception
     * @return Response|bool
     */
    public function bulkDestroy(BulkDestroyQcDepartment $request) : Response
    {
        DB::transaction(static function () use ($request) {
            collect($request->data['ids'])
                ->chunk(1000)
                ->each(static function ($bulkChunk) {
                    QcDepartment::whereIn('id', $bulkChunk)->delete();

                    // TODO your code goes here
                });
        });

        return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
    }
}
