<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\ProngsType\BulkDestroyProngsType;
use App\Http\Requests\Admin\ProngsType\DestroyProngsType;
use App\Http\Requests\Admin\ProngsType\IndexProngsType;
use App\Http\Requests\Admin\ProngsType\StoreProngsType;
use App\Http\Requests\Admin\ProngsType\UpdateProngsType;
use App\Models\ProngsType;
use Brackets\AdminListing\Facades\AdminListing;
use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Contracts\View\Factory;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Response;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\DB;
use Illuminate\View\View;

class ProngsTypeController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @param IndexProngsType $request
     * @return array|Factory|View
     */
    public function index(IndexProngsType $request)
    {
        // create and AdminListing instance for a specific model and
        $data = AdminListing::create(ProngsType::class)->processRequestAndGet(
            // pass the request with params
            $request,

            // set columns to query
            ['id', 'prongs_type', 'status'],

            // set columns to searchIn
            ['id', 'prongs_type']
        );

        if ($request->ajax()) {
            if ($request->has('bulk')) {
                return [
                    'bulkItems' => $data->pluck('id')
                ];
            }
            return ['data' => $data];
        }

        return view('admin.prongs-type.index', ['data' => $data]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function create()
    {
        $this->authorize('admin.prongs-type.create');

        return view('admin.prongs-type.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param StoreProngsType $request
     * @return array|RedirectResponse|Redirector
     */
    public function store(StoreProngsType $request)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Store the ProngsType
        $prongsType = ProngsType::create($sanitized);

        if ($request->ajax()) {
            return ['redirect' => url('admin/prongs-types'), 'message' => trans('brackets/admin-ui::admin.operation.succeeded')];
        }

        return redirect('admin/prongs-types');
    }

    /**
     * Display the specified resource.
     *
     * @param ProngsType $prongsType
     * @throws AuthorizationException
     * @return void
     */
    public function show(ProngsType $prongsType)
    {
        $this->authorize('admin.prongs-type.show', $prongsType);

        // TODO your code goes here
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param ProngsType $prongsType
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function edit(ProngsType $prongsType)
    {
        $this->authorize('admin.prongs-type.edit', $prongsType);


        return view('admin.prongs-type.edit', [
            'prongsType' => $prongsType,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param UpdateProngsType $request
     * @param ProngsType $prongsType
     * @return array|RedirectResponse|Redirector
     */
    public function update(UpdateProngsType $request, ProngsType $prongsType)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Update changed values ProngsType
        $prongsType->update($sanitized);

        if ($request->ajax()) {
            return [
                'redirect' => url('admin/prongs-types'),
                'message' => trans('brackets/admin-ui::admin.operation.succeeded'),
            ];
        }

        return redirect('admin/prongs-types');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DestroyProngsType $request
     * @param ProngsType $prongsType
     * @throws Exception
     * @return ResponseFactory|RedirectResponse|Response
     */
    public function destroy(DestroyProngsType $request, ProngsType $prongsType)
    {
        $prongsType->delete();

        if ($request->ajax()) {
            return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
        }

        return redirect()->back();
    }

    /**
     * Remove the specified resources from storage.
     *
     * @param BulkDestroyProngsType $request
     * @throws Exception
     * @return Response|bool
     */
    public function bulkDestroy(BulkDestroyProngsType $request) : Response
    {
        DB::transaction(static function () use ($request) {
            collect($request->data['ids'])
                ->chunk(1000)
                ->each(static function ($bulkChunk) {
                    ProngsType::whereIn('id', $bulkChunk)->delete();

                    // TODO your code goes here
                });
        });

        return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
    }
}
