<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\ProductType\BulkDestroyProductType;
use App\Http\Requests\Admin\ProductType\DestroyProductType;
use App\Http\Requests\Admin\ProductType\IndexProductType;
use App\Http\Requests\Admin\ProductType\StoreProductType;
use App\Http\Requests\Admin\ProductType\UpdateProductType;
use App\Models\ProductType;
use Brackets\AdminListing\Facades\AdminListing;
use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Contracts\View\Factory;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Response;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\DB;
use Illuminate\View\View;
use App\Models\Customer;

class ProductTypeController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @param IndexProductType $request
     * @return array|Factory|View
     */
    public function index(IndexProductType $request)
    {
        // create and AdminListing instance for a specific model and
        $data = AdminListing::create(ProductType::class)->processRequestAndGet(
            // pass the request with params
            $request,

            // set columns to query
            ['id', 'product_type', 'status'],

            // set columns to searchIn
            ['id', 'product_type', 'requirement']
        );

        if ($request->ajax()) {
            if ($request->has('bulk')) {
                return [
                    'bulkItems' => $data->pluck('id')
                ];
            }
            return ['data' => $data];
        }

        return view('admin.product-type.index', ['data' => $data]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function create()
    {
        $this->authorize('admin.product-type.create');
        // $specialassistants=Customer::all();
        $data = collect([
            ['id' => 'ring_size', 'path' => 'Ring Size'],
            ['id' => 'metal_type', 'path' => 'Metal Type'],
            ['id' => 'metal_type', 'path' => 'Metal Purity'],
            ['id' => 'metal_type', 'path' => 'Metal Tone'],
             ['id' => 'metal_type', 'path' => 'Closure'],
             ['id' => 'metal_type', 'path' => 'Wrist Size'],
            ['id' => 'metal_type', 'path' => 'Lock Type'],
            ['id' => 'metal_type', 'path' => 'Prongs Type'],
            ['id' => 'metal_type', 'path' => 'Polish Type'],
        ]);

       
        return view('admin.product-type.create',['specialassistants'=>$data]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param StoreProductType $request
     * @return array|RedirectResponse|Redirector
     */
    public function store(StoreProductType $request)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();
        $assistant_idString = null;
        if (is_array($request->requirement)) {
            $assistant_id = array_map(function($assistant) {
                return $assistant['id'];
            }, $request->requirement);
            // Combine ids into comma-separated string
            $assistant_idString = implode(',', $assistant_id);
        }

        $sanitized['requirement'] = $assistant_idString;

        // Store the ProductType
        $productType = ProductType::create($sanitized);

        if ($request->ajax()) {
            return ['redirect' => url('admin/product-types'), 'message' => trans('brackets/admin-ui::admin.operation.succeeded')];
        }

        return redirect('admin/product-types');
    }

    /**
     * Display the specified resource.
     *
     * @param ProductType $productType
     * @throws AuthorizationException
     * @return void
     */
    public function show(ProductType $productType)
    {
        $this->authorize('admin.product-type.show', $productType);

        // TODO your code goes here
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param ProductType $productType
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function edit(ProductType $productType)
    {
        $this->authorize('admin.product-type.edit', $productType);
        $data = collect([
            ['id' => 'ring_size', 'path' => 'Ring Size'],
            ['id' => 'metal_type', 'path' => 'Metal Type'],
            ['id' => 'metal_type', 'path' => 'Metal Purity'],
            ['id' => 'metal_type', 'path' => 'Metal Tone'],
             ['id' => 'metal_type', 'path' => 'Closure'],
             ['id' => 'metal_type', 'path' => 'Wrist Size'],
            ['id' => 'metal_type', 'path' => 'Lock Type'],
            ['id' => 'metal_type', 'path' => 'Prongs Type'],
            ['id' => 'metal_type', 'path' => 'Polish Type'],
        ]);
   
        // $productType->load('requirement');

        return view('admin.product-type.edit', [
            'productType' => $productType,
            'specialassistants'=>$data,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param UpdateProductType $request
     * @param ProductType $productType
     * @return array|RedirectResponse|Redirector
     */
    public function update(UpdateProductType $request, ProductType $productType)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Update changed values ProductType
        $productType->update($sanitized);

        if ($request->ajax()) {
            return [
                'redirect' => url('admin/product-types'),
                'message' => trans('brackets/admin-ui::admin.operation.succeeded'),
            ];
        }

        return redirect('admin/product-types');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DestroyProductType $request
     * @param ProductType $productType
     * @throws Exception
     * @return ResponseFactory|RedirectResponse|Response
     */
    public function destroy(DestroyProductType $request, ProductType $productType)
    {
        $productType->delete();

        if ($request->ajax()) {
            return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
        }

        return redirect()->back();
    }

    /**
     * Remove the specified resources from storage.
     *
     * @param BulkDestroyProductType $request
     * @throws Exception
     * @return Response|bool
     */
    public function bulkDestroy(BulkDestroyProductType $request) : Response
    {
        DB::transaction(static function () use ($request) {
            collect($request->data['ids'])
                ->chunk(1000)
                ->each(static function ($bulkChunk) {
                    ProductType::whereIn('id', $bulkChunk)->delete();

                    // TODO your code goes here
                });
        });

        return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
    }
}
