<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\Priority\BulkDestroyPriority;
use App\Http\Requests\Admin\Priority\DestroyPriority;
use App\Http\Requests\Admin\Priority\IndexPriority;
use App\Http\Requests\Admin\Priority\StorePriority;
use App\Http\Requests\Admin\Priority\UpdatePriority;
use App\Models\Priority;
use Brackets\AdminListing\Facades\AdminListing;
use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Contracts\View\Factory;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Response;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\DB;
use Illuminate\View\View;

class PriorityController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @param IndexPriority $request
     * @return array|Factory|View
     */
    public function index(IndexPriority $request)
    {
        // create and AdminListing instance for a specific model and
        $data = AdminListing::create(Priority::class)->processRequestAndGet(
            // pass the request with params
            $request,

            // set columns to query
            ['id', 'priority', 'status'],

            // set columns to searchIn
            ['id', 'priority']
        );

        if ($request->ajax()) {
            if ($request->has('bulk')) {
                return [
                    'bulkItems' => $data->pluck('id')
                ];
            }
            return ['data' => $data];
        }

        return view('admin.priority.index', ['data' => $data]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function create()
    {
        $this->authorize('admin.priority.create');

        return view('admin.priority.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param StorePriority $request
     * @return array|RedirectResponse|Redirector
     */
    public function store(StorePriority $request)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Store the Priority
        $priority = Priority::create($sanitized);

        if ($request->ajax()) {
            return ['redirect' => url('admin/priorities'), 'message' => trans('brackets/admin-ui::admin.operation.succeeded')];
        }

        return redirect('admin/priorities');
    }

    /**
     * Display the specified resource.
     *
     * @param Priority $priority
     * @throws AuthorizationException
     * @return void
     */
    public function show(Priority $priority)
    {
        $this->authorize('admin.priority.show', $priority);

        // TODO your code goes here
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param Priority $priority
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function edit(Priority $priority)
    {
        $this->authorize('admin.priority.edit', $priority);


        return view('admin.priority.edit', [
            'priority' => $priority,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param UpdatePriority $request
     * @param Priority $priority
     * @return array|RedirectResponse|Redirector
     */
    public function update(UpdatePriority $request, Priority $priority)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Update changed values Priority
        $priority->update($sanitized);

        if ($request->ajax()) {
            return [
                'redirect' => url('admin/priorities'),
                'message' => trans('brackets/admin-ui::admin.operation.succeeded'),
            ];
        }

        return redirect('admin/priorities');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DestroyPriority $request
     * @param Priority $priority
     * @throws Exception
     * @return ResponseFactory|RedirectResponse|Response
     */
    public function destroy(DestroyPriority $request, Priority $priority)
    {
        $priority->delete();

        if ($request->ajax()) {
            return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
        }

        return redirect()->back();
    }

    /**
     * Remove the specified resources from storage.
     *
     * @param BulkDestroyPriority $request
     * @throws Exception
     * @return Response|bool
     */
    public function bulkDestroy(BulkDestroyPriority $request) : Response
    {
        DB::transaction(static function () use ($request) {
            collect($request->data['ids'])
                ->chunk(1000)
                ->each(static function ($bulkChunk) {
                    Priority::whereIn('id', $bulkChunk)->delete();

                    // TODO your code goes here
                });
        });

        return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
    }
}
