<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\PolishType\BulkDestroyPolishType;
use App\Http\Requests\Admin\PolishType\DestroyPolishType;
use App\Http\Requests\Admin\PolishType\IndexPolishType;
use App\Http\Requests\Admin\PolishType\StorePolishType;
use App\Http\Requests\Admin\PolishType\UpdatePolishType;
use App\Models\PolishType;
use Brackets\AdminListing\Facades\AdminListing;
use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Contracts\View\Factory;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Response;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\DB;
use Illuminate\View\View;

class PolishTypeController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @param IndexPolishType $request
     * @return array|Factory|View
     */
    public function index(IndexPolishType $request)
    {
        // create and AdminListing instance for a specific model and
        $data = AdminListing::create(PolishType::class)->processRequestAndGet(
            // pass the request with params
            $request,

            // set columns to query
            ['id', 'polish_type', 'status'],

            // set columns to searchIn
            ['id', 'polish_type']
        );

        if ($request->ajax()) {
            if ($request->has('bulk')) {
                return [
                    'bulkItems' => $data->pluck('id')
                ];
            }
            return ['data' => $data];
        }

        return view('admin.polish-type.index', ['data' => $data]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function create()
    {
        $this->authorize('admin.polish-type.create');

        return view('admin.polish-type.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param StorePolishType $request
     * @return array|RedirectResponse|Redirector
     */
    public function store(StorePolishType $request)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Store the PolishType
        $polishType = PolishType::create($sanitized);

        if ($request->ajax()) {
            return ['redirect' => url('admin/polish-types'), 'message' => trans('brackets/admin-ui::admin.operation.succeeded')];
        }

        return redirect('admin/polish-types');
    }

    /**
     * Display the specified resource.
     *
     * @param PolishType $polishType
     * @throws AuthorizationException
     * @return void
     */
    public function show(PolishType $polishType)
    {
        $this->authorize('admin.polish-type.show', $polishType);

        // TODO your code goes here
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param PolishType $polishType
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function edit(PolishType $polishType)
    {
        $this->authorize('admin.polish-type.edit', $polishType);


        return view('admin.polish-type.edit', [
            'polishType' => $polishType,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param UpdatePolishType $request
     * @param PolishType $polishType
     * @return array|RedirectResponse|Redirector
     */
    public function update(UpdatePolishType $request, PolishType $polishType)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Update changed values PolishType
        $polishType->update($sanitized);

        if ($request->ajax()) {
            return [
                'redirect' => url('admin/polish-types'),
                'message' => trans('brackets/admin-ui::admin.operation.succeeded'),
            ];
        }

        return redirect('admin/polish-types');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DestroyPolishType $request
     * @param PolishType $polishType
     * @throws Exception
     * @return ResponseFactory|RedirectResponse|Response
     */
    public function destroy(DestroyPolishType $request, PolishType $polishType)
    {
        $polishType->delete();

        if ($request->ajax()) {
            return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
        }

        return redirect()->back();
    }

    /**
     * Remove the specified resources from storage.
     *
     * @param BulkDestroyPolishType $request
     * @throws Exception
     * @return Response|bool
     */
    public function bulkDestroy(BulkDestroyPolishType $request) : Response
    {
        DB::transaction(static function () use ($request) {
            collect($request->data['ids'])
                ->chunk(1000)
                ->each(static function ($bulkChunk) {
                    PolishType::whereIn('id', $bulkChunk)->delete();

                    // TODO your code goes here
                });
        });

        return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
    }
}
