<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\PartyName\BulkDestroyPartyName;
use App\Http\Requests\Admin\PartyName\DestroyPartyName;
use App\Http\Requests\Admin\PartyName\IndexPartyName;
use App\Http\Requests\Admin\PartyName\StorePartyName;
use App\Http\Requests\Admin\PartyName\UpdatePartyName;
use App\Models\PartyName;
use Brackets\AdminListing\Facades\AdminListing;
use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Contracts\View\Factory;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Response;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\DB;
use Illuminate\View\View;

class PartyNameController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @param IndexPartyName $request
     * @return array|Factory|View
     */
    public function index(IndexPartyName $request)
    {
        // create and AdminListing instance for a specific model and
        $data = AdminListing::create(PartyName::class)->processRequestAndGet(
            // pass the request with params
            $request,

            // set columns to query
            ['id', 'name_code', 'name', 'number', 'email', 'status'],

            // set columns to searchIn
            ['id', 'name_code', 'name', 'number', 'email']
        );

        if ($request->ajax()) {
            if ($request->has('bulk')) {
                return [
                    'bulkItems' => $data->pluck('id')
                ];
            }
            return ['data' => $data];
        }

        return view('admin.party-name.index', ['data' => $data]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function create()
    {
        $this->authorize('admin.party-name.create');

        return view('admin.party-name.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param StorePartyName $request
     * @return array|RedirectResponse|Redirector
     */
    public function store(StorePartyName $request)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Store the PartyName
        $partyName = PartyName::create($sanitized);

        if ($request->ajax()) {
            return ['redirect' => url('admin/party-names'), 'message' => trans('brackets/admin-ui::admin.operation.succeeded')];
        }

        return redirect('admin/party-names');
    }

    /**
     * Display the specified resource.
     *
     * @param PartyName $partyName
     * @throws AuthorizationException
     * @return void
     */
    public function show(PartyName $partyName)
    {
        $this->authorize('admin.party-name.show', $partyName);

        // TODO your code goes here
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param PartyName $partyName
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function edit(PartyName $partyName)
    {
        $this->authorize('admin.party-name.edit', $partyName);


        return view('admin.party-name.edit', [
            'partyName' => $partyName,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param UpdatePartyName $request
     * @param PartyName $partyName
     * @return array|RedirectResponse|Redirector
     */
    public function update(UpdatePartyName $request, PartyName $partyName)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Update changed values PartyName
        $partyName->update($sanitized);

        if ($request->ajax()) {
            return [
                'redirect' => url('admin/party-names'),
                'message' => trans('brackets/admin-ui::admin.operation.succeeded'),
            ];
        }

        return redirect('admin/party-names');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DestroyPartyName $request
     * @param PartyName $partyName
     * @throws Exception
     * @return ResponseFactory|RedirectResponse|Response
     */
    public function destroy(DestroyPartyName $request, PartyName $partyName)
    {
        $partyName->delete();

        if ($request->ajax()) {
            return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
        }

        return redirect()->back();
    }

    /**
     * Remove the specified resources from storage.
     *
     * @param BulkDestroyPartyName $request
     * @throws Exception
     * @return Response|bool
     */
    public function bulkDestroy(BulkDestroyPartyName $request) : Response
    {
        DB::transaction(static function () use ($request) {
            collect($request->data['ids'])
                ->chunk(1000)
                ->each(static function ($bulkChunk) {
                    PartyName::whereIn('id', $bulkChunk)->delete();

                    // TODO your code goes here
                });
        });

        return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
    }
}
