<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\MetalTone\BulkDestroyMetalTone;
use App\Http\Requests\Admin\MetalTone\DestroyMetalTone;
use App\Http\Requests\Admin\MetalTone\IndexMetalTone;
use App\Http\Requests\Admin\MetalTone\StoreMetalTone;
use App\Http\Requests\Admin\MetalTone\UpdateMetalTone;
use App\Models\MetalTone;
use Brackets\AdminListing\Facades\AdminListing;
use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Contracts\View\Factory;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Response;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\DB;
use Illuminate\View\View;

class MetalToneController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @param IndexMetalTone $request
     * @return array|Factory|View
     */
    public function index(IndexMetalTone $request)
    {
        // create and AdminListing instance for a specific model and
        $data = AdminListing::create(MetalTone::class)->processRequestAndGet(
            // pass the request with params
            $request,

            // set columns to query
            ['id', 'metal_tone', 'status'],

            // set columns to searchIn
            ['id', 'metal_tone']
        );

        if ($request->ajax()) {
            if ($request->has('bulk')) {
                return [
                    'bulkItems' => $data->pluck('id')
                ];
            }
            return ['data' => $data];
        }

        return view('admin.metal-tone.index', ['data' => $data]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function create()
    {
        $this->authorize('admin.metal-tone.create');

        return view('admin.metal-tone.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param StoreMetalTone $request
     * @return array|RedirectResponse|Redirector
     */
    public function store(StoreMetalTone $request)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Store the MetalTone
        $metalTone = MetalTone::create($sanitized);

        if ($request->ajax()) {
            return ['redirect' => url('admin/metal-tones'), 'message' => trans('brackets/admin-ui::admin.operation.succeeded')];
        }

        return redirect('admin/metal-tones');
    }

    /**
     * Display the specified resource.
     *
     * @param MetalTone $metalTone
     * @throws AuthorizationException
     * @return void
     */
    public function show(MetalTone $metalTone)
    {
        $this->authorize('admin.metal-tone.show', $metalTone);

        // TODO your code goes here
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param MetalTone $metalTone
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function edit(MetalTone $metalTone)
    {
        $this->authorize('admin.metal-tone.edit', $metalTone);


        return view('admin.metal-tone.edit', [
            'metalTone' => $metalTone,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param UpdateMetalTone $request
     * @param MetalTone $metalTone
     * @return array|RedirectResponse|Redirector
     */
    public function update(UpdateMetalTone $request, MetalTone $metalTone)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Update changed values MetalTone
        $metalTone->update($sanitized);

        if ($request->ajax()) {
            return [
                'redirect' => url('admin/metal-tones'),
                'message' => trans('brackets/admin-ui::admin.operation.succeeded'),
            ];
        }

        return redirect('admin/metal-tones');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DestroyMetalTone $request
     * @param MetalTone $metalTone
     * @throws Exception
     * @return ResponseFactory|RedirectResponse|Response
     */
    public function destroy(DestroyMetalTone $request, MetalTone $metalTone)
    {
        $metalTone->delete();

        if ($request->ajax()) {
            return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
        }

        return redirect()->back();
    }

    /**
     * Remove the specified resources from storage.
     *
     * @param BulkDestroyMetalTone $request
     * @throws Exception
     * @return Response|bool
     */
    public function bulkDestroy(BulkDestroyMetalTone $request) : Response
    {
        DB::transaction(static function () use ($request) {
            collect($request->data['ids'])
                ->chunk(1000)
                ->each(static function ($bulkChunk) {
                    MetalTone::whereIn('id', $bulkChunk)->delete();

                    // TODO your code goes here
                });
        });

        return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
    }
}
