<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\MetalPurity\BulkDestroyMetalPurity;
use App\Http\Requests\Admin\MetalPurity\DestroyMetalPurity;
use App\Http\Requests\Admin\MetalPurity\IndexMetalPurity;
use App\Http\Requests\Admin\MetalPurity\StoreMetalPurity;
use App\Http\Requests\Admin\MetalPurity\UpdateMetalPurity;
use App\Models\MetalPurity;
use Brackets\AdminListing\Facades\AdminListing;
use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Contracts\View\Factory;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Response;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\DB;
use Illuminate\View\View;

class MetalPurityController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @param IndexMetalPurity $request
     * @return array|Factory|View
     */
    public function index(IndexMetalPurity $request)
    {
        // create and AdminListing instance for a specific model and
        $data = AdminListing::create(MetalPurity::class)->processRequestAndGet(
            // pass the request with params
            $request,

            // set columns to query
            ['id', 'purity', 'status'],

            // set columns to searchIn
            ['id', 'purity']
        );

        if ($request->ajax()) {
            if ($request->has('bulk')) {
                return [
                    'bulkItems' => $data->pluck('id')
                ];
            }
            return ['data' => $data];
        }

        return view('admin.metal-purity.index', ['data' => $data]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function create()
    {
        $this->authorize('admin.metal-purity.create');

        return view('admin.metal-purity.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param StoreMetalPurity $request
     * @return array|RedirectResponse|Redirector
     */
    public function store(StoreMetalPurity $request)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Store the MetalPurity
        $metalPurity = MetalPurity::create($sanitized);

        if ($request->ajax()) {
            return ['redirect' => url('admin/metal-purities'), 'message' => trans('brackets/admin-ui::admin.operation.succeeded')];
        }

        return redirect('admin/metal-purities');
    }

    /**
     * Display the specified resource.
     *
     * @param MetalPurity $metalPurity
     * @throws AuthorizationException
     * @return void
     */
    public function show(MetalPurity $metalPurity)
    {
        $this->authorize('admin.metal-purity.show', $metalPurity);

        // TODO your code goes here
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param MetalPurity $metalPurity
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function edit(MetalPurity $metalPurity)
    {
        $this->authorize('admin.metal-purity.edit', $metalPurity);


        return view('admin.metal-purity.edit', [
            'metalPurity' => $metalPurity,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param UpdateMetalPurity $request
     * @param MetalPurity $metalPurity
     * @return array|RedirectResponse|Redirector
     */
    public function update(UpdateMetalPurity $request, MetalPurity $metalPurity)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Update changed values MetalPurity
        $metalPurity->update($sanitized);

        if ($request->ajax()) {
            return [
                'redirect' => url('admin/metal-purities'),
                'message' => trans('brackets/admin-ui::admin.operation.succeeded'),
            ];
        }

        return redirect('admin/metal-purities');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DestroyMetalPurity $request
     * @param MetalPurity $metalPurity
     * @throws Exception
     * @return ResponseFactory|RedirectResponse|Response
     */
    public function destroy(DestroyMetalPurity $request, MetalPurity $metalPurity)
    {
        $metalPurity->delete();

        if ($request->ajax()) {
            return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
        }

        return redirect()->back();
    }

    /**
     * Remove the specified resources from storage.
     *
     * @param BulkDestroyMetalPurity $request
     * @throws Exception
     * @return Response|bool
     */
    public function bulkDestroy(BulkDestroyMetalPurity $request) : Response
    {
        DB::transaction(static function () use ($request) {
            collect($request->data['ids'])
                ->chunk(1000)
                ->each(static function ($bulkChunk) {
                    MetalPurity::whereIn('id', $bulkChunk)->delete();

                    // TODO your code goes here
                });
        });

        return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
    }
}
