<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\LockType\BulkDestroyLockType;
use App\Http\Requests\Admin\LockType\DestroyLockType;
use App\Http\Requests\Admin\LockType\IndexLockType;
use App\Http\Requests\Admin\LockType\StoreLockType;
use App\Http\Requests\Admin\LockType\UpdateLockType;
use App\Models\LockType;
use Brackets\AdminListing\Facades\AdminListing;
use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Contracts\View\Factory;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Response;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\DB;
use Illuminate\View\View;

class LockTypeController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @param IndexLockType $request
     * @return array|Factory|View
     */
    public function index(IndexLockType $request)
    {
        // create and AdminListing instance for a specific model and
        $data = AdminListing::create(LockType::class)->processRequestAndGet(
            // pass the request with params
            $request,

            // set columns to query
            ['id', 'lock_type', 'status'],

            // set columns to searchIn
            ['id', 'lock_type']
        );

        if ($request->ajax()) {
            if ($request->has('bulk')) {
                return [
                    'bulkItems' => $data->pluck('id')
                ];
            }
            return ['data' => $data];
        }

        return view('admin.lock-type.index', ['data' => $data]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function create()
    {
        $this->authorize('admin.lock-type.create');

        return view('admin.lock-type.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param StoreLockType $request
     * @return array|RedirectResponse|Redirector
     */
    public function store(StoreLockType $request)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Store the LockType
        $lockType = LockType::create($sanitized);

        if ($request->ajax()) {
            return ['redirect' => url('admin/lock-types'), 'message' => trans('brackets/admin-ui::admin.operation.succeeded')];
        }

        return redirect('admin/lock-types');
    }

    /**
     * Display the specified resource.
     *
     * @param LockType $lockType
     * @throws AuthorizationException
     * @return void
     */
    public function show(LockType $lockType)
    {
        $this->authorize('admin.lock-type.show', $lockType);

        // TODO your code goes here
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param LockType $lockType
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function edit(LockType $lockType)
    {
        $this->authorize('admin.lock-type.edit', $lockType);


        return view('admin.lock-type.edit', [
            'lockType' => $lockType,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param UpdateLockType $request
     * @param LockType $lockType
     * @return array|RedirectResponse|Redirector
     */
    public function update(UpdateLockType $request, LockType $lockType)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Update changed values LockType
        $lockType->update($sanitized);

        if ($request->ajax()) {
            return [
                'redirect' => url('admin/lock-types'),
                'message' => trans('brackets/admin-ui::admin.operation.succeeded'),
            ];
        }

        return redirect('admin/lock-types');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DestroyLockType $request
     * @param LockType $lockType
     * @throws Exception
     * @return ResponseFactory|RedirectResponse|Response
     */
    public function destroy(DestroyLockType $request, LockType $lockType)
    {
        $lockType->delete();

        if ($request->ajax()) {
            return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
        }

        return redirect()->back();
    }

    /**
     * Remove the specified resources from storage.
     *
     * @param BulkDestroyLockType $request
     * @throws Exception
     * @return Response|bool
     */
    public function bulkDestroy(BulkDestroyLockType $request) : Response
    {
        DB::transaction(static function () use ($request) {
            collect($request->data['ids'])
                ->chunk(1000)
                ->each(static function ($bulkChunk) {
                    LockType::whereIn('id', $bulkChunk)->delete();

                    // TODO your code goes here
                });
        });

        return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
    }
}
