<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\DiamondType\BulkDestroyDiamondType;
use App\Http\Requests\Admin\DiamondType\DestroyDiamondType;
use App\Http\Requests\Admin\DiamondType\IndexDiamondType;
use App\Http\Requests\Admin\DiamondType\StoreDiamondType;
use App\Http\Requests\Admin\DiamondType\UpdateDiamondType;
use App\Models\DiamondType;
use Brackets\AdminListing\Facades\AdminListing;
use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Contracts\View\Factory;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Response;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\DB;
use Illuminate\View\View;

class DiamondTypeController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @param IndexDiamondType $request
     * @return array|Factory|View
     */
    public function index(IndexDiamondType $request)
    {
        // create and AdminListing instance for a specific model and
        $data = AdminListing::create(DiamondType::class)->processRequestAndGet(
            // pass the request with params
            $request,

            // set columns to query
            ['id', 'type', 'status'],

            // set columns to searchIn
            ['id', 'type']
        );

        if ($request->ajax()) {
            if ($request->has('bulk')) {
                return [
                    'bulkItems' => $data->pluck('id')
                ];
            }
            return ['data' => $data];
        }

        return view('admin.diamond-type.index', ['data' => $data]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function create()
    {
        $this->authorize('admin.diamond-type.create');

        return view('admin.diamond-type.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param StoreDiamondType $request
     * @return array|RedirectResponse|Redirector
     */
    public function store(StoreDiamondType $request)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Store the DiamondType
        $diamondType = DiamondType::create($sanitized);

        if ($request->ajax()) {
            return ['redirect' => url('admin/diamond-types'), 'message' => trans('brackets/admin-ui::admin.operation.succeeded')];
        }

        return redirect('admin/diamond-types');
    }

    /**
     * Display the specified resource.
     *
     * @param DiamondType $diamondType
     * @throws AuthorizationException
     * @return void
     */
    public function show(DiamondType $diamondType)
    {
        $this->authorize('admin.diamond-type.show', $diamondType);

        // TODO your code goes here
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param DiamondType $diamondType
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function edit(DiamondType $diamondType)
    {
        $this->authorize('admin.diamond-type.edit', $diamondType);


        return view('admin.diamond-type.edit', [
            'diamondType' => $diamondType,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param UpdateDiamondType $request
     * @param DiamondType $diamondType
     * @return array|RedirectResponse|Redirector
     */
    public function update(UpdateDiamondType $request, DiamondType $diamondType)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Update changed values DiamondType
        $diamondType->update($sanitized);

        if ($request->ajax()) {
            return [
                'redirect' => url('admin/diamond-types'),
                'message' => trans('brackets/admin-ui::admin.operation.succeeded'),
            ];
        }

        return redirect('admin/diamond-types');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DestroyDiamondType $request
     * @param DiamondType $diamondType
     * @throws Exception
     * @return ResponseFactory|RedirectResponse|Response
     */
    public function destroy(DestroyDiamondType $request, DiamondType $diamondType)
    {
        $diamondType->delete();

        if ($request->ajax()) {
            return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
        }

        return redirect()->back();
    }

    /**
     * Remove the specified resources from storage.
     *
     * @param BulkDestroyDiamondType $request
     * @throws Exception
     * @return Response|bool
     */
    public function bulkDestroy(BulkDestroyDiamondType $request) : Response
    {
        DB::transaction(static function () use ($request) {
            collect($request->data['ids'])
                ->chunk(1000)
                ->each(static function ($bulkChunk) {
                    DiamondType::whereIn('id', $bulkChunk)->delete();

                    // TODO your code goes here
                });
        });

        return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
    }
}
