<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\DiamondShape\BulkDestroyDiamondShape;
use App\Http\Requests\Admin\DiamondShape\DestroyDiamondShape;
use App\Http\Requests\Admin\DiamondShape\IndexDiamondShape;
use App\Http\Requests\Admin\DiamondShape\StoreDiamondShape;
use App\Http\Requests\Admin\DiamondShape\UpdateDiamondShape;
use App\Models\DiamondShape;
use Brackets\AdminListing\Facades\AdminListing;
use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Contracts\View\Factory;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Response;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\DB;
use Illuminate\View\View;

class DiamondShapeController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @param IndexDiamondShape $request
     * @return array|Factory|View
     */
    public function index(IndexDiamondShape $request)
    {
        // create and AdminListing instance for a specific model and
        $data = AdminListing::create(DiamondShape::class)->processRequestAndGet(
            // pass the request with params
            $request,

            // set columns to query
            ['id', 'shape', 'status'],

            // set columns to searchIn
            ['id', 'shape']
        );

        if ($request->ajax()) {
            if ($request->has('bulk')) {
                return [
                    'bulkItems' => $data->pluck('id')
                ];
            }
            return ['data' => $data];
        }

        return view('admin.diamond-shape.index', ['data' => $data]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function create()
    {
        $this->authorize('admin.diamond-shape.create');

        return view('admin.diamond-shape.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param StoreDiamondShape $request
     * @return array|RedirectResponse|Redirector
     */
    public function store(StoreDiamondShape $request)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Store the DiamondShape
        $diamondShape = DiamondShape::create($sanitized);

        if ($request->ajax()) {
            return ['redirect' => url('admin/diamond-shapes'), 'message' => trans('brackets/admin-ui::admin.operation.succeeded')];
        }

        return redirect('admin/diamond-shapes');
    }

    /**
     * Display the specified resource.
     *
     * @param DiamondShape $diamondShape
     * @throws AuthorizationException
     * @return void
     */
    public function show(DiamondShape $diamondShape)
    {
        $this->authorize('admin.diamond-shape.show', $diamondShape);

        // TODO your code goes here
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param DiamondShape $diamondShape
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function edit(DiamondShape $diamondShape)
    {
        $this->authorize('admin.diamond-shape.edit', $diamondShape);


        return view('admin.diamond-shape.edit', [
            'diamondShape' => $diamondShape,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param UpdateDiamondShape $request
     * @param DiamondShape $diamondShape
     * @return array|RedirectResponse|Redirector
     */
    public function update(UpdateDiamondShape $request, DiamondShape $diamondShape)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Update changed values DiamondShape
        $diamondShape->update($sanitized);

        if ($request->ajax()) {
            return [
                'redirect' => url('admin/diamond-shapes'),
                'message' => trans('brackets/admin-ui::admin.operation.succeeded'),
            ];
        }

        return redirect('admin/diamond-shapes');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DestroyDiamondShape $request
     * @param DiamondShape $diamondShape
     * @throws Exception
     * @return ResponseFactory|RedirectResponse|Response
     */
    public function destroy(DestroyDiamondShape $request, DiamondShape $diamondShape)
    {
        $diamondShape->delete();

        if ($request->ajax()) {
            return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
        }

        return redirect()->back();
    }

    /**
     * Remove the specified resources from storage.
     *
     * @param BulkDestroyDiamondShape $request
     * @throws Exception
     * @return Response|bool
     */
    public function bulkDestroy(BulkDestroyDiamondShape $request) : Response
    {
        DB::transaction(static function () use ($request) {
            collect($request->data['ids'])
                ->chunk(1000)
                ->each(static function ($bulkChunk) {
                    DiamondShape::whereIn('id', $bulkChunk)->delete();

                    // TODO your code goes here
                });
        });

        return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
    }
}
