<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\DiamondOrder\BulkDestroyDiamondOrder;
use App\Http\Requests\Admin\DiamondOrder\DestroyDiamondOrder;
use App\Http\Requests\Admin\DiamondOrder\IndexDiamondOrder;
use App\Http\Requests\Admin\DiamondOrder\StoreDiamondOrder;
use App\Http\Requests\Admin\DiamondOrder\UpdateDiamondOrder;
use App\Models\DiamondOrder;
use Brackets\AdminListing\Facades\AdminListing;
use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Contracts\View\Factory;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Response;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\DB;
use Illuminate\View\View;
use App\Models\DiamondType;
use App\Models\DiamondShape;
use App\Models\CaratWeight;
use App\Models\StoneColor;

class DiamondOrderController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @param IndexDiamondOrder $request
     * @return array|Factory|View
     */
    public function index(IndexDiamondOrder $request)
    {
        // create and AdminListing instance for a specific model and
        $data = AdminListing::create(DiamondOrder::class)->processRequestAndGet(
            // pass the request with params
            $request,

            // set columns to query
            ['id', 'order_id', 'diamond_type', 'diamond_stock_type', 'diamond_shape', 'carat_weight', 'stone_color', 'length', 'width', 'height', 'certificate_number'],

            // set columns to searchIn
            ['id', 'certificate_number']
        );

        if ($request->ajax()) {
            if ($request->has('bulk')) {
                return [
                    'bulkItems' => $data->pluck('id')
                ];
            }
            return ['data' => $data];
        }

        return view('admin.diamond-order.index', ['data' => $data]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function create()
    {
        $this->authorize('admin.diamond-order.create');  

        $DiamondType = DiamondType::where('status',1)->get();
        $DiamondShape = DiamondShape::where('status',1)->get();
        $CaratWeight = CaratWeight::where('status',1)->get();
        $StoneColor = StoneColor::where('status',1)->get();
        $DiamondStockType = collect([
            (object)['id' => '0', 'type' => 'Custom'],
            (object)['id' => '1', 'type' => 'In Stock'],
            (object)['id' => '2', 'type' => 'Purchase'],
        ]);



        return view('admin.diamond-order.create',[
            'DiamondType' => $DiamondType,
            'DiamondShape' => $DiamondShape,
            'CaratWeight'=>$CaratWeight,
            'StoneColor'=>$StoneColor,
            'DiamondStockType'=>$DiamondStockType
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param StoreDiamondOrder $request
     * @return array|RedirectResponse|Redirector
     */
    public function store(StoreDiamondOrder $request)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Store the DiamondOrder
        $diamondOrder = DiamondOrder::create($sanitized);

        if ($request->ajax()) {
            return ['redirect' => url('admin/diamond-orders'), 'message' => trans('brackets/admin-ui::admin.operation.succeeded')];
        }

        return redirect('admin/diamond-orders');
    }

    /**
     * Display the specified resource.
     *
     * @param DiamondOrder $diamondOrder
     * @throws AuthorizationException
     * @return void
     */
    public function show(DiamondOrder $diamondOrder)
    {
        $this->authorize('admin.diamond-order.show', $diamondOrder);

        // TODO your code goes here
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param DiamondOrder $diamondOrder
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function edit(DiamondOrder $diamondOrder)
    {
        $this->authorize('admin.diamond-order.edit', $diamondOrder);

        $DiamondType = DiamondType::where('status',1)->get();
        $DiamondShape = DiamondShape::where('status',1)->get();
        $CaratWeight = CaratWeight::where('status',1)->get();
        $StoneColor = StoneColor::where('status',1)->get();
        $DiamondStockType = collect([
            (object)['id' => '0', 'type' => 'Custom'],
            (object)['id' => '1', 'type' => 'In Stock'],
            (object)['id' => '2', 'type' => 'Purchase'],
        ]);


        return view('admin.diamond-order.edit', [
            'diamondOrder' => $diamondOrder,
            'DiamondType' => $DiamondType,
            'DiamondShape' => $DiamondShape,
            'CaratWeight'=>$CaratWeight,
            'StoneColor'=>$StoneColor,
            'DiamondStockType'=>$DiamondStockType
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param UpdateDiamondOrder $request
     * @param DiamondOrder $diamondOrder
     * @return array|RedirectResponse|Redirector
     */
    public function update(UpdateDiamondOrder $request, DiamondOrder $diamondOrder)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Update changed values DiamondOrder
        $diamondOrder->update($sanitized);

        if ($request->ajax()) {
            return [
                'redirect' => url('admin/diamond-orders'),
                'message' => trans('brackets/admin-ui::admin.operation.succeeded'),
            ];
        }

        return redirect('admin/diamond-orders');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DestroyDiamondOrder $request
     * @param DiamondOrder $diamondOrder
     * @throws Exception
     * @return ResponseFactory|RedirectResponse|Response
     */
    public function destroy(DestroyDiamondOrder $request, DiamondOrder $diamondOrder)
    {
        $diamondOrder->delete();

        if ($request->ajax()) {
            return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
        }

        return redirect()->back();
    }

    /**
     * Remove the specified resources from storage.
     *
     * @param BulkDestroyDiamondOrder $request
     * @throws Exception
     * @return Response|bool
     */
    public function bulkDestroy(BulkDestroyDiamondOrder $request) : Response
    {
        DB::transaction(static function () use ($request) {
            collect($request->data['ids'])
                ->chunk(1000)
                ->each(static function ($bulkChunk) {
                    DiamondOrder::whereIn('id', $bulkChunk)->delete();

                    // TODO your code goes here
                });
        });

        return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
    }
}
