<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\Customer\BulkDestroyCustomer;
use App\Http\Requests\Admin\Customer\DestroyCustomer;
use App\Http\Requests\Admin\Customer\IndexCustomer;
use App\Http\Requests\Admin\Customer\StoreCustomer;
use App\Http\Requests\Admin\Customer\UpdateCustomer;
use App\Models\Customer;
use Brackets\AdminListing\Facades\AdminListing;
use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Contracts\View\Factory;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Response;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\DB;
use Illuminate\View\View;
use App\Models\PartyName;
use App\Models\BrokerName;
use App\Models\Country;


class CustomersController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @param IndexCustomer $request
     * @return array|Factory|View
     */
    public function index(IndexCustomer $request)
    {
        // create and AdminListing instance for a specific model and
        $data = AdminListing::create(Customer::class)->processRequestAndGet(
            // pass the request with params
            $request,

            // set columns to query
            ['id','customer_id', 'first_name', 'last_name', 'party_id', 'broker_id', 'city', 'state', 'zipcode', 'country_id', 'number', 'email', 'status'],

            // set columns to searchIn
            ['id','customer_id', 'first_name', 'last_name', 'address_1', 'address_2', 'city', 'state', 'zipcode', 'number', 'email']
        );

        if ($request->ajax()) {
            if ($request->has('bulk')) {
                return [
                    'bulkItems' => $data->pluck('id')
                ];
            }
            return ['data' => $data];
        }

        return view('admin.customer.index', ['data' => $data]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function create()
    {
        $this->authorize('admin.customer.create');
        $PartyName = PartyName::where('status',1)->get();
        $BrokerName = BrokerName::where('status',1)->get();
        $Country = Country::where('status',1)->get();
        // countries

        return view('admin.customer.create',['PartyName'=>$PartyName,'BrokerName'=>$BrokerName,'Country'=>$Country]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param StoreCustomer $request
     * @return array|RedirectResponse|Redirector
     */
    public function store(StoreCustomer $request)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        $PartyName = PartyName::where('id',$sanitized['party_id'])->get();
        $BrokerName = BrokerName::where('id',$sanitized['broker_id'])->get();

        // dd($sanitized);
        // Store the Customer
        
        $customer = Customer::create($sanitized);
        $customer_id = $PartyName[0]['name_code'] .'-'.$BrokerName[0]['name_code'].'-'.$customer['id'];
        $customer->customer_id = $customer_id;
        $customer->save();

        if ($request->ajax()) {
            return ['redirect' => url('admin/customers'), 'message' => trans('brackets/admin-ui::admin.operation.succeeded')];
        }

        return redirect('admin/customers');
    }

    /**
     * Display the specified resource.
     *
     * @param Customer $customer
     * @throws AuthorizationException
     * @return void
     */
    public function show(Customer $customer)
    {
        $this->authorize('admin.customer.show', $customer);

        // TODO your code goes here
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param Customer $customer
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function edit(Customer $customer)
    {
        $this->authorize('admin.customer.edit', $customer);

        $PartyName = PartyName::where('status',1)->get();
        $BrokerName = BrokerName::where('status',1)->get();
        $Country = Country::where('status',1)->get();

        return view('admin.customer.edit', [
            'customer' => $customer,
            'PartyName'=>$PartyName,
            'BrokerName'=>$BrokerName,
            'Country'=>$Country
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param UpdateCustomer $request
     * @param Customer $customer
     * @return array|RedirectResponse|Redirector
     */
    public function update(UpdateCustomer $request, Customer $customer)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();
       
        // $PartyName = PartyName::where('id',$sanitized['party_id'])->get();
        // $BrokerName = BrokerName::where('id',$sanitized['broker_id'])->get();
        // $customer_id = $PartyName[0]['name_code'] .'-'.$BrokerName[0]['name_code'].'-'.$sanitized['id'];

        // $sanitized['customer_id'] = $customer_id;

        // Update changed values Customer
        $customer->update($sanitized);

        if ($request->ajax()) {
            return [
                'redirect' => url('admin/customers'),
                'message' => trans('brackets/admin-ui::admin.operation.succeeded'),
            ];
        }

        return redirect('admin/customers');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DestroyCustomer $request
     * @param Customer $customer
     * @throws Exception
     * @return ResponseFactory|RedirectResponse|Response
     */
    public function destroy(DestroyCustomer $request, Customer $customer)
    {
        $customer->delete();

        if ($request->ajax()) {
            return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
        }

        return redirect()->back();
    }

    /**
     * Remove the specified resources from storage.
     *
     * @param BulkDestroyCustomer $request
     * @throws Exception
     * @return Response|bool
     */
    public function bulkDestroy(BulkDestroyCustomer $request) : Response
    {
        DB::transaction(static function () use ($request) {
            collect($request->data['ids'])
                ->chunk(1000)
                ->each(static function ($bulkChunk) {
                    Customer::whereIn('id', $bulkChunk)->delete();

                    // TODO your code goes here
                });
        });

        return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
    }
}
