<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\CaratWeight\BulkDestroyCaratWeight;
use App\Http\Requests\Admin\CaratWeight\DestroyCaratWeight;
use App\Http\Requests\Admin\CaratWeight\IndexCaratWeight;
use App\Http\Requests\Admin\CaratWeight\StoreCaratWeight;
use App\Http\Requests\Admin\CaratWeight\UpdateCaratWeight;
use App\Models\CaratWeight;
use Brackets\AdminListing\Facades\AdminListing;
use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Contracts\View\Factory;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Response;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\DB;
use Illuminate\View\View;

class CaratWeightController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @param IndexCaratWeight $request
     * @return array|Factory|View
     */
    public function index(IndexCaratWeight $request)
    {
        // create and AdminListing instance for a specific model and
        $data = AdminListing::create(CaratWeight::class)->processRequestAndGet(
            // pass the request with params
            $request,

            // set columns to query
            ['id', 'weight', 'status'],

            // set columns to searchIn
            ['id', 'weight']
        );

        if ($request->ajax()) {
            if ($request->has('bulk')) {
                return [
                    'bulkItems' => $data->pluck('id')
                ];
            }
            return ['data' => $data];
        }

        return view('admin.carat-weight.index', ['data' => $data]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function create()
    {
        $this->authorize('admin.carat-weight.create');

        return view('admin.carat-weight.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param StoreCaratWeight $request
     * @return array|RedirectResponse|Redirector
     */
    public function store(StoreCaratWeight $request)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Store the CaratWeight
        $caratWeight = CaratWeight::create($sanitized);

        if ($request->ajax()) {
            return ['redirect' => url('admin/carat-weights'), 'message' => trans('brackets/admin-ui::admin.operation.succeeded')];
        }

        return redirect('admin/carat-weights');
    }

    /**
     * Display the specified resource.
     *
     * @param CaratWeight $caratWeight
     * @throws AuthorizationException
     * @return void
     */
    public function show(CaratWeight $caratWeight)
    {
        $this->authorize('admin.carat-weight.show', $caratWeight);

        // TODO your code goes here
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param CaratWeight $caratWeight
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function edit(CaratWeight $caratWeight)
    {
        $this->authorize('admin.carat-weight.edit', $caratWeight);


        return view('admin.carat-weight.edit', [
            'caratWeight' => $caratWeight,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param UpdateCaratWeight $request
     * @param CaratWeight $caratWeight
     * @return array|RedirectResponse|Redirector
     */
    public function update(UpdateCaratWeight $request, CaratWeight $caratWeight)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Update changed values CaratWeight
        $caratWeight->update($sanitized);

        if ($request->ajax()) {
            return [
                'redirect' => url('admin/carat-weights'),
                'message' => trans('brackets/admin-ui::admin.operation.succeeded'),
            ];
        }

        return redirect('admin/carat-weights');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DestroyCaratWeight $request
     * @param CaratWeight $caratWeight
     * @throws Exception
     * @return ResponseFactory|RedirectResponse|Response
     */
    public function destroy(DestroyCaratWeight $request, CaratWeight $caratWeight)
    {
        $caratWeight->delete();

        if ($request->ajax()) {
            return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
        }

        return redirect()->back();
    }

    /**
     * Remove the specified resources from storage.
     *
     * @param BulkDestroyCaratWeight $request
     * @throws Exception
     * @return Response|bool
     */
    public function bulkDestroy(BulkDestroyCaratWeight $request) : Response
    {
        DB::transaction(static function () use ($request) {
            collect($request->data['ids'])
                ->chunk(1000)
                ->each(static function ($bulkChunk) {
                    CaratWeight::whereIn('id', $bulkChunk)->delete();

                    // TODO your code goes here
                });
        });

        return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
    }
}
