<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\BrokerName\BulkDestroyBrokerName;
use App\Http\Requests\Admin\BrokerName\DestroyBrokerName;
use App\Http\Requests\Admin\BrokerName\IndexBrokerName;
use App\Http\Requests\Admin\BrokerName\StoreBrokerName;
use App\Http\Requests\Admin\BrokerName\UpdateBrokerName;
use App\Models\BrokerName;
use Brackets\AdminListing\Facades\AdminListing;
use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Contracts\View\Factory;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Response;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\DB;
use Illuminate\View\View;

class BrokerNameController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @param IndexBrokerName $request
     * @return array|Factory|View
     */
    public function index(IndexBrokerName $request)
    {
        // create and AdminListing instance for a specific model and
        $data = AdminListing::create(BrokerName::class)->processRequestAndGet(
            // pass the request with params
            $request,

            // set columns to query
            ['id', 'name_code', 'name', 'number', 'email', 'status'],

            // set columns to searchIn
            ['id', 'name_code', 'name', 'number', 'email']
        );

        if ($request->ajax()) {
            if ($request->has('bulk')) {
                return [
                    'bulkItems' => $data->pluck('id')
                ];
            }
            return ['data' => $data];
        }

        return view('admin.broker-name.index', ['data' => $data]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function create()
    {
        $this->authorize('admin.broker-name.create');

        return view('admin.broker-name.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param StoreBrokerName $request
     * @return array|RedirectResponse|Redirector
     */
    public function store(StoreBrokerName $request)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Store the BrokerName
        $brokerName = BrokerName::create($sanitized);

        if ($request->ajax()) {
            return ['redirect' => url('admin/broker-names'), 'message' => trans('brackets/admin-ui::admin.operation.succeeded')];
        }

        return redirect('admin/broker-names');
    }

    /**
     * Display the specified resource.
     *
     * @param BrokerName $brokerName
     * @throws AuthorizationException
     * @return void
     */
    public function show(BrokerName $brokerName)
    {
        $this->authorize('admin.broker-name.show', $brokerName);

        // TODO your code goes here
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param BrokerName $brokerName
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function edit(BrokerName $brokerName)
    {
        $this->authorize('admin.broker-name.edit', $brokerName);


        return view('admin.broker-name.edit', [
            'brokerName' => $brokerName,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param UpdateBrokerName $request
     * @param BrokerName $brokerName
     * @return array|RedirectResponse|Redirector
     */
    public function update(UpdateBrokerName $request, BrokerName $brokerName)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Update changed values BrokerName
        $brokerName->update($sanitized);

        if ($request->ajax()) {
            return [
                'redirect' => url('admin/broker-names'),
                'message' => trans('brackets/admin-ui::admin.operation.succeeded'),
            ];
        }

        return redirect('admin/broker-names');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DestroyBrokerName $request
     * @param BrokerName $brokerName
     * @throws Exception
     * @return ResponseFactory|RedirectResponse|Response
     */
    public function destroy(DestroyBrokerName $request, BrokerName $brokerName)
    {
        $brokerName->delete();

        if ($request->ajax()) {
            return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
        }

        return redirect()->back();
    }

    /**
     * Remove the specified resources from storage.
     *
     * @param BulkDestroyBrokerName $request
     * @throws Exception
     * @return Response|bool
     */
    public function bulkDestroy(BulkDestroyBrokerName $request) : Response
    {
        DB::transaction(static function () use ($request) {
            collect($request->data['ids'])
                ->chunk(1000)
                ->each(static function ($bulkChunk) {
                    BrokerName::whereIn('id', $bulkChunk)->delete();

                    // TODO your code goes here
                });
        });

        return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
    }
}
