<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\BaleType\BulkDestroyBaleType;
use App\Http\Requests\Admin\BaleType\DestroyBaleType;
use App\Http\Requests\Admin\BaleType\IndexBaleType;
use App\Http\Requests\Admin\BaleType\StoreBaleType;
use App\Http\Requests\Admin\BaleType\UpdateBaleType;
use App\Models\BaleType;
use Brackets\AdminListing\Facades\AdminListing;
use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Contracts\View\Factory;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Response;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\DB;
use Illuminate\View\View;

class BaleTypeController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @param IndexBaleType $request
     * @return array|Factory|View
     */
    public function index(IndexBaleType $request)
    {
        // create and AdminListing instance for a specific model and
        $data = AdminListing::create(BaleType::class)->processRequestAndGet(
            // pass the request with params
            $request,

            // set columns to query
            ['id', 'bale_type', 'status'],

            // set columns to searchIn
            ['id', 'bale_type']
        );

        if ($request->ajax()) {
            if ($request->has('bulk')) {
                return [
                    'bulkItems' => $data->pluck('id')
                ];
            }
            return ['data' => $data];
        }

        return view('admin.bale-type.index', ['data' => $data]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function create()
    {
        $this->authorize('admin.bale-type.create');

        return view('admin.bale-type.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param StoreBaleType $request
     * @return array|RedirectResponse|Redirector
     */
    public function store(StoreBaleType $request)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Store the BaleType
        $baleType = BaleType::create($sanitized);

        if ($request->ajax()) {
            return ['redirect' => url('admin/bale-types'), 'message' => trans('brackets/admin-ui::admin.operation.succeeded')];
        }

        return redirect('admin/bale-types');
    }

    /**
     * Display the specified resource.
     *
     * @param BaleType $baleType
     * @throws AuthorizationException
     * @return void
     */
    public function show(BaleType $baleType)
    {
        $this->authorize('admin.bale-type.show', $baleType);

        // TODO your code goes here
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param BaleType $baleType
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function edit(BaleType $baleType)
    {
        $this->authorize('admin.bale-type.edit', $baleType);


        return view('admin.bale-type.edit', [
            'baleType' => $baleType,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param UpdateBaleType $request
     * @param BaleType $baleType
     * @return array|RedirectResponse|Redirector
     */
    public function update(UpdateBaleType $request, BaleType $baleType)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Update changed values BaleType
        $baleType->update($sanitized);

        if ($request->ajax()) {
            return [
                'redirect' => url('admin/bale-types'),
                'message' => trans('brackets/admin-ui::admin.operation.succeeded'),
            ];
        }

        return redirect('admin/bale-types');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DestroyBaleType $request
     * @param BaleType $baleType
     * @throws Exception
     * @return ResponseFactory|RedirectResponse|Response
     */
    public function destroy(DestroyBaleType $request, BaleType $baleType)
    {
        $baleType->delete();

        if ($request->ajax()) {
            return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
        }

        return redirect()->back();
    }

    /**
     * Remove the specified resources from storage.
     *
     * @param BulkDestroyBaleType $request
     * @throws Exception
     * @return Response|bool
     */
    public function bulkDestroy(BulkDestroyBaleType $request) : Response
    {
        DB::transaction(static function () use ($request) {
            collect($request->data['ids'])
                ->chunk(1000)
                ->each(static function ($bulkChunk) {
                    BaleType::whereIn('id', $bulkChunk)->delete();

                    // TODO your code goes here
                });
        });

        return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
    }
}
